package jamezo97.clonecraft.Synchronize;

import jamezo97.clonecraft.Logger;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;

import org.apache.commons.lang3.ArrayUtils;

public class ClassData {
	
	private HashMap<Integer, Field> idToField = new HashMap<Integer, Field>();
	
	private HashMap<Integer, int[]> subidToIds = new HashMap<Integer, int[]>();
	
	private HashMap<Integer, Integer> idToChannel = new HashMap<Integer, Integer>();
	
	public ClassData(Class c){
		load(c);
	}
	
	public Field getFieldForId(int id){
		return idToField.get(id);
	}
	
	public int[] getIdsForCallId(int subid){
		return subidToIds.get(subid);
	}
	
	public int getIdChannel(int id){
		if(idToChannel.containsKey(id)){
			return idToChannel.get(id);
		}
		return -1;
	}
	
	public Iterator<Entry<Integer, Field>> getIdToFieldIterator() {
		return idToField.entrySet().iterator();
	}
	
	public void load(Class c){
		HashMap<Integer, ArrayList<Integer>> subidToData = new HashMap<Integer, ArrayList<Integer>>();
		Field[] fields = c.getDeclaredFields();
		for(int a = 0; a < fields.length; a++){
			Field field = fields[a];
			SyncValue annot = field.getAnnotation(SyncValue.class);
			if(annot != null){
				int id = annot.uniqueId();
				if(!idToField.containsKey(id)){
					field.setAccessible(true);
					int channel = annot.channel();
					int subId = annot.subId();
					idToField.put(id, field);
					idToChannel.put(id, channel);
					
					if(!subidToData.containsKey(subId)){
						subidToData.put(subId, new ArrayList<Integer>());
					}
					subidToData.get(subId).add(id);
				}else{
					Logger.error("Duplicate annotation ID: " + id);
				}	
			}
		}
		Iterator<Entry<Integer, ArrayList<Integer>>> it = subidToData.entrySet().iterator();
		while(it.hasNext()){
			Entry<Integer, ArrayList<Integer>> entry = it.next();
			int subid = entry.getKey();
			ArrayList<Integer> values = entry.getValue();
			int[] ids = ArrayUtils.toPrimitive(values.toArray(new Integer[values.size()]));
			subidToIds.put(subid, ids);
		}
	}

	
	

}
